/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.license;

import ibm.nways.jdm.license.BorderLabel;
import ibm.nways.jdm.license.LicenseInfo;
import ibm.nways.jdm.license.LicenseServiceClient;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class LicenseServerStatus
extends Applet
implements WindowListener {
    private ResourceBundle myResources;
    private static String bundleName = "ibm.nways.jdm.license.LicenseResourceBundle";
    public static String host;
    public static boolean application;
    public static boolean menuStart;
    public Frame frame = new Frame("License Status");

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        if (application) {
            this.frame.add(component, gridBagConstraints);
        }
    }

    public void init() {
        if (!application) {
            host = this.getCodeBase().getHost();
        } else {
            ((Component)this.frame).setSize(900, 300);
            ((Component)this.frame).setBackground(Color.blue);
            this.frame.setForeground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.frame.setLayout(gridBagLayout);
            this.frame.addWindowListener(this);
        }
        System.out.println("*********** Host: " + host + "********");
    }

    public void start() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            this.remove(componentArray[n]);
            ++n;
        }
        this.setBackground(Color.blue);
        this.setForeground(Color.white);
        if (this.myResources == null) {
            this.myResources = ResourceBundle.getBundle(bundleName);
        }
        System.out.println("*********** ResourceBundle: " + bundleName + "********");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        BorderLabel borderLabel = new BorderLabel("Product Name");
        this.add(borderLabel, gridBagLayout, gridBagConstraints, 0, 0, 2, 1);
        BorderLabel borderLabel2 = new BorderLabel("License Status");
        this.add(borderLabel2, gridBagLayout, gridBagConstraints, 2, 0, 1, 1);
        BorderLabel borderLabel3 = new BorderLabel("Expiration Date/Expired Date");
        this.add(borderLabel3, gridBagLayout, gridBagConstraints, 3, 0, 2, 1);
        BorderLabel borderLabel4 = new BorderLabel("Licensed Nodes");
        this.add(borderLabel4, gridBagLayout, gridBagConstraints, 5, 0, 0, 1);
        LicenseServiceClient licenseServiceClient = new LicenseServiceClient();
        if (!licenseServiceClient.init(host)) {
            System.out.println("******* Connect to Remote host failed **********");
            System.exit(0);
        }
        Vector vector = licenseServiceClient.getLicenseInfoList();
        LicenseInfo licenseInfo = new LicenseInfo();
        Date date = new Date(1310000000L);
        Date date2 = new Date(System.currentTimeMillis());
        int n2 = 1;
        System.out.println("@@@@@@@@******* License Info Dates **********@@@@@@@@@@@");
        System.out.println("******* Old Date (3) : " + date + " **********");
        System.out.println("******* Today's Date : " + date2 + " **********");
        if (vector == null) {
            System.out.println("******* License Info List is null **********");
            System.exit(1);
        }
        System.out.println("******* Info List size : " + vector.size() + "**********");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Date date3;
            BorderLabel borderLabel5;
            BorderLabel borderLabel6;
            int n3 = 0;
            System.out.println("******* Entered loop to get License info **********");
            licenseInfo = (LicenseInfo)enumeration.nextElement();
            System.out.println("******* License info " + licenseInfo + " **********");
            String string = licenseInfo.getProductNameKey();
            System.out.println("******* Name key " + string + " to get License info **********");
            String string2 = this.myResources.getString(string);
            System.out.println("******* Product Name " + string2 + " to get License info **********");
            BorderLabel borderLabel7 = new BorderLabel(string2);
            this.add(borderLabel7, gridBagLayout, gridBagConstraints, n3, n2, 2, 2);
            ++n3;
            ++n3;
            int n4 = licenseInfo.getRegistrationStatus();
            System.out.println("******* RegStatus : " + n4 + " **********");
            if (n4 == 0) {
                borderLabel6 = new BorderLabel("Permanent");
                this.add(borderLabel6, gridBagLayout, gridBagConstraints, n3, n2, 1, 2);
                borderLabel5 = new BorderLabel("          ----------          ");
                this.add(borderLabel5, gridBagLayout, gridBagConstraints, ++n3, n2, 2, 2);
                ++n3;
                ++n3;
            }
            if (n4 == 1) {
                borderLabel6 = new BorderLabel("Trial");
                this.add(borderLabel6, gridBagLayout, gridBagConstraints, n3, n2, 1, 2);
                date3 = licenseInfo.getExpirationDate();
                borderLabel5 = new BorderLabel(date3.toString());
                this.add(borderLabel5, gridBagLayout, gridBagConstraints, ++n3, n2, 2, 2);
                ++n3;
                ++n3;
                System.out.println("******* Expiration Date : " + date3 + " **********");
            }
            if (n4 == 2) {
                borderLabel6 = new BorderLabel("License Expired");
                this.add(borderLabel6, gridBagLayout, gridBagConstraints, n3, n2, 1, 2);
                date3 = licenseInfo.getExpirationDate();
                borderLabel5 = date.after(date3) || date3.after(date2) ? new BorderLabel("          ----------          ") : new BorderLabel(date3.toString());
                this.add(borderLabel5, gridBagLayout, gridBagConstraints, ++n3, n2, 2, 2);
                ++n3;
                ++n3;
                System.out.println("******* Expiration Date : " + date3 + " **********");
            }
            int n5 = licenseInfo.getLicensedNodes();
            System.out.println("******* LicensedNodes : " + n5 + " **********");
            borderLabel6 = new BorderLabel(Integer.toString(n5));
            this.add(borderLabel6, gridBagLayout, gridBagConstraints, n3, n2, 1, 2);
            int n6 = licenseInfo.getMaxNodes();
            System.out.println("******* MaxNodes : " + n6 + " **********");
            int n7 = licenseInfo.getCurrentNodes();
            System.out.println("******* CurrentNodes : " + n7 + " **********");
            n2 += 2;
        }
        if (application) {
            this.frame.show();
            System.out.println("********* menuStart : " + menuStart + "********");
            System.out.println("********* application : " + application + "********");
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (application) {
            if (menuStart) {
                System.exit(0);
                return;
            }
            this.frame.dispose();
            return;
        }
        this.destroy();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        application = true;
        System.out.println("******* Entered main **********");
        LicenseServerStatus licenseServerStatus = new LicenseServerStatus();
        System.out.println("******* Calling init method **********");
        licenseServerStatus.init();
        System.out.println("******* Calling start method **********");
        licenseServerStatus.start();
    }

    static {
        menuStart = true;
    }
}

